import { StyleSheet } from "react-native";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import { I18nManager } from "react-native";

export const itemDescriptionStyle = StyleSheet.create({
    container: {
        flexDirection: "row",
        justifyContent: "space-between",
        paddingTop: dpr(30),
        borderBottomWidth: 1,
        borderBottomColor: "#DFDFDF",
        zIndex: -5,
    },
    subCont: {
        borderBottomWidth: 1,
        borderBottomColor: "#DFDFDF",
    },
    headerText: {
        textAlign: "center",
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        paddingBottom: dpr(10.25),
    },
    boxWithShadow: {
        shadowColor: "#c3c3c3",
        shadowOffset: {
            width: 0,
            height: 12,
        },
        shadowOpacity: 0.5,
        elevation: 24,
        backgroundColor: "#FFFFFF",
    },
    description: {
        overflow: "hidden",
        width: dpr("wf"),
    },
    dynamicHeight: (showMore, descriptionHeight) => ({
        height: showMore ? dpr(250) : descriptionHeight,
    }),
    staticHeight: {
        height: dpr(250),
    },
    indicator: {
        borderBottomWidth: 2,
        borderColor: "#FCCA19",
        top: dpr(56) * 1.09,
        zIndex: 5,
    },
    indicatorWidth: (width) => ({ width: width }),
    seeMore: {
        backgroundColor: "#fff",
        flexDirection: "row",
        justifyContent: "center",
    },
    seeMoreText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#898989",
        marginVertical: dpr(20),
    },
    opacityZero: {
        opacity: 0
    },
    positionRelative: {
        position: "relative",
    },
    descriptionAnimateView: {
        marginHorizontal: -dpr(20),
        marginTop: dpr(5)
    },
});
